/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.search.common;

import dev.xkmc.l2artifacts.content.client.tooltip.ItemTooltip;
import dev.xkmc.l2artifacts.content.misc.ArtifactChestItem;
import dev.xkmc.l2artifacts.content.search.tabs.FilterTabManager;
import dev.xkmc.l2artifacts.content.search.tabs.FilterTabToken;
import dev.xkmc.l2artifacts.content.search.tabs.IFilterScreen;
import dev.xkmc.l2artifacts.content.search.token.ArtifactChestToken;
import dev.xkmc.l2artifacts.content.search.token.ArtifactFilter;
import dev.xkmc.l2artifacts.content.search.token.IArtifactFeature;
import dev.xkmc.l2library.base.menu.base.MenuLayoutConfig;
import dev.xkmc.l2library.base.menu.base.SpriteManager;
import dev.xkmc.l2library.base.menu.stacked.CellEntry;
import dev.xkmc.l2library.base.menu.stacked.StackedRenderHandle;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public abstract class StackedScreen
extends Screen
implements IFilterScreen {
    public final ArtifactChestToken token;
    private final SpriteManager manager;
    private final FilterTabToken<?> tab;
    private int imageWidth;
    private int imageHeight;
    private int leftPos;
    private int topPos;
    protected boolean pressed = false;
    @Nullable
    private FilterHover hover;

    public static void renderHighlight(GuiGraphics g, int x, int y, int w, int h, int c) {
        g.m_285978_(RenderType.m_286086_(), x, y, x + w, y + h, c, c, 0);
    }

    protected StackedScreen(Component title, SpriteManager manager, FilterTabToken<?> tab, ArtifactChestToken token) {
        super(title);
        this.token = token;
        this.tab = tab;
        this.manager = manager;
    }

    protected void m_7856_() {
        this.imageWidth = this.manager.get().getWidth();
        this.imageHeight = this.manager.get().getHeight();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        new FilterTabManager(this, this.token).init(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, this.tab);
    }

    protected void renderInit() {
    }

    protected void renderPost(GuiGraphics pose) {
    }

    protected abstract void renderText(StackedRenderHandle var1, int var2, int var3, int var4);

    protected abstract boolean isAvailable(int var1, int var2);

    protected void renderItem(GuiGraphics g, FilterHover hover) {
        IArtifactFeature iArtifactFeature = hover.item;
        if (iArtifactFeature instanceof IArtifactFeature.Sprite) {
            IArtifactFeature.Sprite icon = (IArtifactFeature.Sprite)iArtifactFeature;
            g.m_280163_(icon.getIcon(), hover.x, hover.y, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            iArtifactFeature = hover.item;
            if (iArtifactFeature instanceof IArtifactFeature.ItemIcon) {
                IArtifactFeature.ItemIcon icon = (IArtifactFeature.ItemIcon)iArtifactFeature;
                this.renderSlotItem(g, hover.x, hover.y, icon.getItemIcon().m_7968_());
            }
        }
    }

    public final void m_88315_(GuiGraphics g, int mx, int my, float pTick) {
        this.renderBg(g, pTick, mx, my);
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_((float)this.leftPos, (float)this.topPos, 0.0f);
        StackedRenderHandle handle = new StackedRenderHandle((Screen)this, g, this.manager.get());
        this.hover = null;
        this.renderInit();
        ArrayList<FilterHover> list = new ArrayList<FilterHover>();
        for (int i = 0; i < this.token.filters.size(); ++i) {
            ArtifactFilter<?> filter = this.token.filters.get(i);
            this.renderText(handle, i, mx, my);
            for (int j = 0; j < filter.allEntries.size(); ++j) {
                boolean selected = filter.getSelected(j);
                IArtifactFeature item = (IArtifactFeature)filter.allEntries.get(j);
                CellEntry entry = handle.addCell(selected, !this.isAvailable(i, j));
                FilterHover obj = new FilterHover(item, i, j, entry.x(), entry.y());
                if (this.isHovering(entry.x(), entry.y(), 16, 16, mx, my)) {
                    this.hover = obj;
                }
                list.add(obj);
            }
        }
        handle.flushText();
        list.forEach(e -> this.renderItem(g, (FilterHover)e));
        if (this.hover != null) {
            StackedScreen.renderHighlight(g, this.hover.x, this.hover.y, 16, 16, -2130706433);
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            texts.add(this.hover.item().getDesc());
            Optional<TooltipComponent> comp = Optional.ofNullable(this.hover.item().getTooltipItems()).map(ItemTooltip::new);
            g.m_280677_(this.f_96547_, texts, comp, mx - this.leftPos, my - this.topPos);
        }
        this.renderPost(g);
        g.m_280168_().m_85849_();
        super.m_88315_(g, mx, my, pTick);
    }

    private void renderBg(GuiGraphics g, float pt, int mx, int my) {
        MenuLayoutConfig menuLayoutConfig = this.manager.get();
        Objects.requireNonNull(menuLayoutConfig);
        MenuLayoutConfig.ScreenRenderer sr = new MenuLayoutConfig.ScreenRenderer(menuLayoutConfig, (Screen)this, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        sr.start(g);
    }

    protected boolean isHovering(int x, int y, int w, int h, double mx, double my) {
        int i = this.leftPos;
        int j = this.topPos;
        return (mx -= (double)i) >= (double)(x - 1) && mx < (double)(x + w + 1) && (my -= (double)j) >= (double)(y - 1) && my < (double)(y + h + 1);
    }

    private void renderSlotItem(GuiGraphics g, int x, int y, ItemStack stack) {
        assert (this.f_96541_ != null);
        assert (this.f_96541_.f_91074_ != null);
        g.m_280256_(stack, x, y, x + y * this.imageWidth);
        g.m_280302_(this.f_96547_, stack, x, y, null);
    }

    protected abstract void clickHover(int var1, int var2);

    @Override
    public void onSwitch() {
        CompoundTag filter = TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)this.token);
        assert (filter != null);
        ArtifactChestItem.setFilter(Proxy.getClientPlayer().m_150109_().m_8020_(this.token.invSlot), filter);
    }

    public boolean m_6375_(double mx, double my, int button) {
        this.pressed = true;
        if (super.m_6375_(mx, my, button)) {
            return true;
        }
        if (this.hover != null) {
            this.clickHover(this.hover.i, this.hover.j);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.pressed = false;
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public int getGuiLeft() {
        return this.leftPos;
    }

    @Override
    public int getGuiTop() {
        return this.topPos;
    }

    @Override
    public int screenWidth() {
        return this.f_96543_;
    }

    @Override
    public int screenHeight() {
        return this.f_96544_;
    }

    @Override
    public int getXSize() {
        return this.imageWidth;
    }

    @Override
    public int getYSize() {
        return this.imageHeight;
    }

    protected record FilterHover(IArtifactFeature item, int i, int j, int x, int y) {
    }
}

